﻿using System;
using System.Collections.Generic;
using System.Data.Linq;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessAHOBPR.MilitaryInfoService;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis
{
    public class ComprehensiveUpdater : AHOBPRBaseBO, IEmisImporter

    {
        AHOBPRShared _sharedManager;
        eMISMilitaryInformationSerivcePortTypesClient _client;
        InputHeaderInfo _inputHeaderInfo;

        #region constructors
        public ComprehensiveUpdater()
        {
            _client = new eMISMilitaryInformationSerivcePortTypesClient();
            _inputHeaderInfo = new InputHeaderInfo();
            _sharedManager = new AHOBPRShared();
        }
        #endregion
        #region Properties
        public InputHeaderInfo InputHeaderInfo
        {
            get { return _inputHeaderInfo; }
            set { _inputHeaderInfo = value; }
        }
        #endregion
        public void GetEmisInfoForRegistrant(string edipi, string ssn, IRegistrantManager registrantManager)
        {
            //use the AHOBPRRegistrantManager to get info from DB on the Registrant
            if (registrantManager == null) { registrantManager = new AHOBPRRegistrantManager(); }
            REGISTRANT registrant = registrantManager.GetRegistrantById(edipi, ssn);

        }
        public string ReconcileQueue(List<IRegistrantUpdater> updateManagers)
        {
            var initialEntries = 0;
            var updatedEntries = 0;
            var duplicates = 0;
            var failedUpdates = 0;
            
            List<UPDATES_BENS_REGISTRANT_NOTIFICATION> queueEntries = GetRegistrantUpdateNotifications();
            
            if (queueEntries.Count > 0)
            {
                initialEntries = queueEntries.Count;
                var processedNotifications = new List<UPDATES_PROCESSED_NOTIFICATION_STATUS>();
                var retirementImporter = new RegistrantRetirementImporter();
                foreach (var entry in queueEntries)
                {
                    var status = string.Empty;
                    var error = string.Empty;
                    UPDATES_PROCESSED_NOTIFICATION_STATUS notification;
                    //go through the list of updators 
                    foreach (IRegistrantUpdater manager in updateManagers)
                    {
                        //If no entrys with this edipi have been processed, then process it
                        if (!processedNotifications.Any(e => e.EDIPI == entry.EDIPI))
                        {
                            var success = manager.Update(entry.EDIPI, entry.REGISTRANT_ID);
                            if (success)
                            {
                                updatedEntries++;
                                status = "success";
                            }
                            else
                            {
                                failedUpdates++;
                                status = "failure";
                            }
                        }
                        else //add it to the list as a duplicate, so it won't be picked up for processing by the stored procedure in the future
                        {
                            duplicates++;
                            status = "duplicate";
                        }
                        notification = CreateProcessedNotification(entry, manager.Name, status, error);
                        processedNotifications.Add(notification);
                    }
                }
                SaveProcessedNotificationStatuses(processedNotifications);
            }

            return "found:" + initialEntries + ",updated:" + updatedEntries + ",failed:" + failedUpdates + ",duplicates:" + duplicates;
        }      

        UPDATES_PROCESSED_NOTIFICATION_STATUS CreateProcessedNotification(UPDATES_BENS_REGISTRANT_NOTIFICATION entry, string processName, string status, string error)
        {
            var notification = new UPDATES_PROCESSED_NOTIFICATION_STATUS();
            notification.UPDATES_BENS_REGISTRANT_NOTIFICATION_ID = entry.UPDATES_BENS_REGISTRANT_NOTIFICATION_ID;
            notification.REGISTRANT_ID = entry.REGISTRANT_ID;
            notification.EDIPI = entry.EDIPI;
            notification.PROCESS_NAME = processName;
            notification.PROCESS_STATUS = status;
            notification.CREATED = DateTime.Now;
            notification.CREATEDBY = "RegistrantUpdator";
            notification.UPDATED = DateTime.Now;
            notification.UPDATEDBY = "RegistrantUpdator";
            notification.PROCESS_ERROR = error;
            return notification;
        }

        #region DB Calls

        public List<UPDATES_BENS_REGISTRANT_NOTIFICATION> GetRegistrantUpdateNotifications()
        {
            var unprocessedNotfications = new List<UPDATES_BENS_REGISTRANT_NOTIFICATION>();
            using (_dbAhobpr = GetDataContext())
            {
                unprocessedNotfications = _dbAhobpr.SP_GetPendingRegistrantUpdates().ToList();
            }
            return unprocessedNotfications;
        }

        private void SaveProcessedNotificationStatuses(List<UPDATES_PROCESSED_NOTIFICATION_STATUS> processedNotifications)
        {
            foreach (UPDATES_PROCESSED_NOTIFICATION_STATUS entry in processedNotifications)
            {
                SaveUpdateNotificationStatus(entry);
            }
        }

        public void SaveUpdateNotificationStatus(UPDATES_PROCESSED_NOTIFICATION_STATUS entry)
        {
            try
            {
                using (_dbAhobpr = GetDataContext())
                {
                    _dbAhobpr.SP_InsertIntoUpdatesProcessed(entry.UPDATES_BENS_REGISTRANT_NOTIFICATION_ID,
                        entry.REGISTRANT_ID, entry.EDIPI, entry.PROCESS_NAME, entry.PROCESS_STATUS, entry.PROCESS_ERROR, entry.CREATEDBY);
                }
            }
            catch (Exception ex)
            {
                _sharedManager.LogErrorMessage("Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message + "; " + ex.StackTrace);
            }
        }
        #endregion
    }
    public class UPDATE_QUEUE
    {
        bool _deleteOnSubmit;
        public int EDIPI { get; set; }
        public bool Delete
        {
            get { return _deleteOnSubmit; }
        }
        public void SetAsDeleteOnSubmit()
        {
            _deleteOnSubmit = true;
        }
    }
}
